#Check if data is over or under-dispersed and if so, re-ran as quasibinomial
#Note: this was checked and adjusted where needed 
#(i.e. 01 data analysis.R was re-run with family set to quasibinomial where necessary)

#*****************************************************************************************#
#note! before sourcing the following script, all families need to be changed to 'binomial'#
#*****************************************************************************************#

#need to set working directory
#setwd()
source("01 data analysis.R")
library(DHARMa)

# List all regressions #can only check for categorical data -----------------------------------
Allregressions_ger1 <-c(regression_list_energy_be,       #beetroot
                        regression_list_energy_on,    #onion
                        regression_list_energy_sp)    #spinach
Allregressions_ger2 <-c(regression_list_capacity_be,     #beetroot
                        regression_list_capacity_on,  #onion
                        regression_list_capacity_sp,  #spinach
                        regression_list_capacity_co,  #coriander
                        regression_list_per_ger,      #perennial ryegrass
                        regression_list_fes_ger)      #red fescue
Allregressions_bio1 <-c(regression_list_pre,          #beetroot-Pythium
                        regression_list_pre_13,       #onion-Fusarium
                        regression_list_Emerge_fin,   #spinach-Pythium
                        regression_list_total_emerge2,#coriander-Pythium
                        regression_list_missing)      #pepper SEEDS
Allregressions_bio2 <-c(regression_list_post_be,      #beetroot-Pythium
                           regression_list_post_13,   #onion-Fusarium
                           regression_list_post,      #spinach-Pythium
                           regression_list_post2,     #coriander-Pythium
                           regression_list_dead)      #pepper SEEDS


#Name seed lots - germination data
names1 <- c(c(201:240), c(101:140), c(301:340))
crops1 <- c(rep('Beetroot', 40),rep('Onion', 40), rep('Spinach', 40))
names2 <- c(c(201:240), c(101:140), c(301:340), c(501:540), c(701:740), c(601:640))
crops2 <- c(rep('Beetroot', 40),rep('Onion', 40), rep('Spinach', 40),
            rep('Coriander', 40),rep('Perennial Ryegrass', 40), rep('Red Fescue', 40))
#Name seed lots - bioassay data
lots <- c(c(201:240), c(101:140), c(301:340), c(501:540), c(401:420))
crops <- c(rep('Beetroot', 40), rep('Onion', 40), rep('Spinach', 40),
           rep('Coriander', 40),rep('Pepper', 20))

# Use testDispersion() Germination -----------------------------------

#underdispersion
underdisp_ger1 <- list()
for(i in 1:length(Allregressions_ger1)){
  underdisp_ger1[[i]] <- testDispersion(
    simulateResiduals(fittedModel = Allregressions_ger1[[i]]), 
    alternative = "less", plot = FALSE)
}

underdisp_ger2 <- list()
for(i in 1:length(Allregressions_ger2)){
  underdisp_ger2[[i]] <- testDispersion(
    simulateResiduals(fittedModel = Allregressions_ger2[[i]]), 
    alternative = "less", plot = FALSE)
}

#overdispersion
overdisp_ger1 <- list()
for(i in 1:length(Allregressions_ger1)){
  overdisp_ger1[[i]] <- testDispersion(
    simulateResiduals(fittedModel = Allregressions_ger1[[i]]), 
    alternative = "greater", plot = FALSE)
}

overdisp_ger2 <- list()
for(i in 1:length(Allregressions_ger2)){
  overdisp_ger2[[i]] <- testDispersion(
    simulateResiduals(fittedModel = Allregressions_ger2[[i]]), 
    alternative = "greater", plot = FALSE)
}

# Extract info from testDispersion() Germination -----------------------------------
#ger1
under_pval1 <- c()
under_statistic1 <- c()
over_pval1 <- c()
over_statistic1 <- c()
for(i in 1:length(Allregressions_ger1)){
  under_pval1[i] <- underdisp_ger1[[i]]$p.value
  under_statistic1[i] <- underdisp_ger1[[i]]$statistic
  over_pval1[i] <- overdisp_ger1[[i]]$p.value
  over_statistic1[i] <- overdisp_ger1[[i]]$statistic
}

#ger2
under_pval2 <- c()
under_statistic2 <- c()
over_pval2 <- c()
over_statistic2 <- c()
for(i in 1:length(Allregressions_ger2)){
  under_pval2[i] <- underdisp_ger2[[i]]$p.value
  under_statistic2[i] <- underdisp_ger2[[i]]$statistic
  over_pval2[i] <- overdisp_ger2[[i]]$p.value
  over_statistic2[i] <- overdisp_ger2[[i]]$statistic
}

# Save data.frame Germination -----------------------------------
dispersion_ger1 <- data.frame(crops1, names1, under_pval1, under_statistic1, over_pval1, over_statistic1)
dispersion_ger2 <- data.frame(crops2, names2,under_pval2, under_statistic2, over_pval2, over_statistic2)

# Use testDispersion() Bioassays -----------------------------------

#underdispersion
underdisp_bio1 <- list()
for(i in 1:length(Allregressions_bio1)){
  underdisp_bio1[[i]] <- testDispersion(
    simulateResiduals(fittedModel = Allregressions_bio1[[i]]), 
    alternative = "less", plot = FALSE)
  #names(regression_list_post)[i] <- regression_list_post[i]
}

underdisp_bio2 <- list()
for(i in 1:length(Allregressions_bio2)){
  underdisp_bio2[[i]] <- testDispersion(
    simulateResiduals(fittedModel = Allregressions_bio2[[i]]), 
    alternative = "less", plot = FALSE)
  #names(regression_list_post)[i] <- regression_list_post[i]
}

#overdispersion
overdisp_bio1 <- list()
for(i in 1:length(Allregressions_bio1)){
  overdisp_bio1[[i]] <- testDispersion(
    simulateResiduals(fittedModel = Allregressions_bio1[[i]]), 
    alternative = "greater", plot = FALSE)
  #names(regression_list_post)[i] <- regression_list_post[i]
}

overdisp_bio2 <- list()
for(i in 1:length(Allregressions_bio2)){
  overdisp_bio2[[i]] <- testDispersion(
    simulateResiduals(fittedModel = Allregressions_bio2[[i]]), 
    alternative = "greater", plot = FALSE)
  #names(regression_list_post)[i] <- regression_list_post[i]
}

# Extract info from testDispersion() Bioassays -----------------------------------
#bio1
under_pval1 <- c()
under_statistic1 <- c()
over_pval1 <- c()
over_statistic1 <- c()
for(i in 1:length(Allregressions_bio1)){
  under_pval1[i] <- underdisp_bio1[[i]]$p.value
  under_statistic1[i] <- underdisp_bio1[[i]]$statistic
  over_pval1[i] <- overdisp_bio1[[i]]$p.value
  over_statistic1[i] <- overdisp_bio1[[i]]$statistic
}

#bio2
under_pval2 <- c()
under_statistic2 <- c()
over_pval2 <- c()
over_statistic2 <- c()
for(i in 1:length(Allregressions_bio2)){
  under_pval2[i] <- underdisp_bio2[[i]]$p.value
  under_statistic2[i] <- underdisp_bio2[[i]]$statistic
  over_pval2[i] <- overdisp_bio2[[i]]$p.value
  over_statistic2[i] <- overdisp_bio2[[i]]$statistic
}

# Save data.frame Bioassays --------------------------------------------------
dispersion_bio <- data.frame(crops, lots, 
                   under_pval1, under_statistic1, over_pval1, over_statistic1,
                   under_pval2, under_statistic2, over_pval2, over_statistic2)
